### **Introduction to AAA Services**

- **Authentication**: Verifies the identity of users or devices accessing the network.
- Example: Similar to showing a driver's license to a security guard.
- **Authorization**: Determines what resources the authenticated user can access.
- Example: The access badge restricts which doors can be opened.
- **Accounting**: Tracks user activities, such as access logs and resource usage.
- Example: Records which doors were accessed and whether access was permitted or denied.

### **Role of Cisco ISE in AAA**

- Acts as a **AAA server** in Cisco Identity-Based Networking Services (IBNS).
- Provides **authentication, authorization, and accounting** for controlled network access.

### **Cisco Secure Network Access Overview**

- Combines **802.1X port authentication** with Cisco ISE to tie user identity to policies.
- Enables differentiated authorization to network services based on user identity.

### **Phases of Wired Port Control in Cisco Secure Network Access**

1. **Supplicant Announcement**: The end-user device (supplicant) announces itself to the authenticator (switch).
2. **Credential Request**: The authenticator prompts the supplicant for credentials.
3. **Credential Submission**: The supplicant provides credentials via the Extensible Authentication Protocol (EAP).

- Common EAP types: EAP-MD5, EAP-TLS, EAP-PEAP, EAP-TTLS, EAP-FAST.
- EAP packets are encapsulated in EAP over LAN (EAPOL) messages.

4. **Credential Forwarding**: The authenticator forwards credentials to the authentication server (Cisco ISE) using RADIUS encapsulation.
5. **Validation and Policy Decision**: Cisco ISE validates credentials and makes a policy decision based on the identity.
6. **Policy Enforcement**: Cisco ISE instructs the authenticator to enforce the policy on the switch port.
7. **Policy Application**: The authenticator enforces the policy.

### **Wireless Network Considerations**

- Similar functionality as wired networks but uses protocols like **WPA2-Enterprise** with 802.1X authentication.
- Wireless clients communicate with the authenticator (WLC).

### **Fallback Authentication Methods**

- **MAC Authentication Bypass (MAB)**: Used for devices without 802.1X support (e.g., printers, IP cameras).
- **Web Authentication**: Used for guest users or devices without supplicant support.

### **Deployment Recommendations**

- **802.1X Authentication**: Deploy on access switches and WLCs in the campus network.
- **Cisco ISE**: Deploy inside data centers to provide authentication services.